#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <richedit.h>
#include <stdlib.h>
#include <time.h>
#include "resource.h"

HINSTANCE hI;
struct
{
	int state;
	int color;
} gb[10][10];

int i, j, curp;
//BYTE *memp;
char buf[1024];
BITMAPINFO bmi;
int rc, bc, cc, todo, todo1, todo2, fp, etp;
HWND cw;
int DrawBoard(HWND);
HDC memdc;
HBITMAP hbmp;
HBRUSH hbr;

BOOL CALLBACK SaveDlgProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	static FILE *file;
	static char buf[512], buf2[64];
	static int c, i;

	switch (msg)
	{
	case WM_INITDIALOG:
		file=fopen("aelevels.aes", "rb");
		if (file==NULL)
			EnableWindow(GetDlgItem(hwnd, IDC_COMBO1), FALSE);
		else
		{
			c=fgetc(file);
			for (i=0; i<c; i++)
			{
				fread((void*)buf, 512, 1, file);
				strncpy(buf2, buf, 64);
				SendDlgItemMessage(hwnd, IDC_COMBO1, CB_ADDSTRING, (WPARAM)0, (LPARAM)buf2);
			}
			EnableWindow(GetDlgItem(hwnd, IDC_COMBO1), TRUE);
			fclose(file);
		}
		SendDlgItemMessage(hwnd, IDC_COMBO1, CB_SETCURSEL, (WPARAM)0, 0);
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wparam))
		{
		case IDOK:
			file=fopen("aelevels.aes", "rb+");
			if (file==NULL)
			{
				file=fopen("aelevels.aes", "wb+");
				fputc(255, file);
				for (i=0; i<256; i++)
				{
					for (i=0; i<256; i++)
					{
						for (j=0; j<512; j++)
							buf[j]='\0';
						sprintf(buf, "Free level position", i);
						fwrite(buf, 512, 1, file);
					}	
				}
			}
			c=SendDlgItemMessage(hwnd, IDC_COMBO1, CB_GETCURSEL, (WPARAM)0, 0);
			GetDlgItemText(hwnd, IDC_EDIT1, buf2, 64);
			strncpy(buf, buf2, 64);
			buf[100]=curp;
			for (i=0; i<10; i++)
			{
				for (j=0; j<10; j++)
				{
					buf[200+i*20+j*2]=gb[i][j].color;
					buf[200+i*20+j*2+1]=gb[i][j].state;
				}
			}
			fseek(file, 512*c+1, SEEK_CUR);
			fwrite(buf, 512, 1, file);
			fclose(file);
			EndDialog(hwnd, 0);
			return 0;
		case IDCANCEL:
			EndDialog(hwnd, 0);
			return 0;
		}
	}
	return 0;
}

int OverLimit(int x, int y, int c)
{
	if (x==0&&y==0&&c>=1)
		return 1;
	if (x==9&&y==0&&c>=1)
		return 1;
	if (x==0&&y==9&&c>=1)
		return 1;
	if (x==9&&y==9&&c>=1)
		return 1;
	if (x==0&&y>0&&y<9&&c>=2)
		return 1;
	if (x==9&&y>0&&y<9&&c>=2)
		return 1;
	if (y==0&&x>0&&x<9&&c>=2)
		return 1;
	if (y==9&&x>0&&x<9&&c>=2)
		return 1;
	if (x>0&&x<9&&y>0&&y<9&&c>=3)
		return 1;
	return 0;
}

void RestartGame(void)
{
	int i;
	if (todo==0)
	{
		for (i=0; i<10; i++)
		{
			for (j=0; j<10; j++)
			{
				gb[i][j].state=0;
				gb[i][j].color=-1;
			}
		}
	}
	else if (todo==1)
	{
		int x, y, c;
		srand(time(NULL));
		for (i=0; i<10; i++)
		{
			for (j=0; j<10; j++)
			{
				gb[i][j].state=0;
				gb[i][j].color=-1;
			}
		}
		c=0;
		for (i=0; i<etp; i++)
		{
			//DrawBoard(cw);
next:
			x=rand()%10;
			y=rand()%10;
			if (todo1==0)
			{
				if (gb[x][y].state!=0)
					goto next;
				gb[x][y].state=1;
				gb[x][y].color=c;
			}
			else
			{
				if (todo2==0)
				{
					if (gb[x][y].color!=c && gb[x][y].color!=-1)
						goto next;
					if (OverLimit(x, y, gb[x][y].state))
						goto next;
					gb[x][y].color=c;
					gb[x][y].state++;
				}
				else
				{
					if (OverLimit(x, y, gb[x][y].state))
						goto next;
					gb[x][y].color=c;
					if (gb[x][y].state<3)
						gb[x][y].state++;
					else
						goto next;
				}
			}
			c++;
			if (c>=2)
				c=0;
		}
	}
	else if (todo==2)
	{
		int c, i, j;
		char buf[512];
		FILE *file=fopen("aelevels.aes", "rb");
		if (file==NULL)
		{
			MessageBox(GetFocus(), "Have you done anything with aelevels.aes file? It's corrupted or can't be opened. Please remove it! You will lose all your saved games. If you want, you can send it to my email, I'll try to repair it... Please send it packed in ZIP ;-)", "Error", MB_OK | MB_ICONASTERISK);
			return;
		}

		c=fgetc(file);
		fseek(file, todo1*512+1, SEEK_SET);
		fread((void*)buf, 512, 1, file);
		fp=buf[100];
		for (i=0; i<10; i++)
		{
			for (j=0; j<10; j++)
			{
				gb[i][j].color=buf[200+i*20+j*2];
				gb[i][j].state=buf[200+i*20+j*2+1];
			}
		}
		fclose(file);
	}
	curp=fp;
	cc=0;
}

BOOL CALLBACK RestartDlgProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	static FILE*file;
	switch (msg)
	{
	case WM_INITDIALOG:
		CheckDlgButton(hwnd, IDC_RADIO1, BST_CHECKED);
		CheckDlgButton(hwnd, IDC_CHECK2, BST_CHECKED);
		CheckDlgButton(hwnd, IDC_CHECK3, BST_UNCHECKED);
		CheckDlgButton(hwnd, IDC_RADIO4, BST_CHECKED);
		CheckDlgButton(hwnd, IDC_RADIO5, BST_UNCHECKED);
		EnableWindow(GetDlgItem(hwnd, IDC_CHECK2), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_CHECK3), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_COMBO1), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_EDIT1), FALSE);
		SetDlgItemInt(hwnd, IDC_EDIT1, 50, FALSE);
		file=fopen("aelevels.aes", "rb");
		if (file==NULL)
			EnableWindow(GetDlgItem(hwnd, IDC_RADIO3), FALSE);
		else
		{
			int c, i;
			char buf[512], buf2[64];

			c=fgetc(file);
			for (i=0; i<c; i++)
			{
				fread((void*)buf, 512, 1, file);
				strncpy(buf2, buf, 64);
				SendDlgItemMessage(hwnd, IDC_COMBO1, CB_ADDSTRING, (WPARAM)0, (LPARAM)buf2);
			}
			EnableWindow(GetDlgItem(hwnd, IDC_RADIO3), TRUE);
			fclose(file);
		}
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wparam))
		{
		case IDC_RADIO1:
			if (HIWORD(wparam)==BN_CLICKED)
			{
				EnableWindow(GetDlgItem(hwnd, IDC_CHECK2), FALSE);
				EnableWindow(GetDlgItem(hwnd, IDC_CHECK3), FALSE);
				EnableWindow(GetDlgItem(hwnd, IDC_COMBO1), FALSE);
				EnableWindow(GetDlgItem(hwnd, IDC_EDIT1), FALSE);
			}
			return 0;
		case IDC_RADIO2:
			if (HIWORD(wparam)==BN_CLICKED)
			{
				EnableWindow(GetDlgItem(hwnd, IDC_CHECK2), TRUE);
				EnableWindow(GetDlgItem(hwnd, IDC_CHECK3), TRUE);
				EnableWindow(GetDlgItem(hwnd, IDC_COMBO1), FALSE);
				EnableWindow(GetDlgItem(hwnd, IDC_EDIT1), TRUE);
			}
			return 0;
		case IDC_RADIO3:
			if (HIWORD(wparam)==BN_CLICKED)
			{
				EnableWindow(GetDlgItem(hwnd, IDC_CHECK2), FALSE);
				EnableWindow(GetDlgItem(hwnd, IDC_CHECK3), FALSE);
				EnableWindow(GetDlgItem(hwnd, IDC_COMBO1), TRUE);
				EnableWindow(GetDlgItem(hwnd, IDC_EDIT1), FALSE);
			}
			return 0;
		case IDOK:
			if (IsDlgButtonChecked(hwnd, IDC_RADIO1) == BST_CHECKED)
			{
				todo=0;
			}
			else if (IsDlgButtonChecked(hwnd, IDC_RADIO2) == BST_CHECKED)
			{
				todo=1;
				todo1=0;
				todo2=0;
				if (IsDlgButtonChecked(hwnd, IDC_CHECK2) == BST_CHECKED)
					todo1=1;
				if (IsDlgButtonChecked(hwnd, IDC_CHECK3) == BST_CHECKED)
					todo2=1;
			}
			else if (IsDlgButtonChecked(hwnd, IDC_RADIO3) == BST_CHECKED)
			{
				todo=2;
				todo1=SendDlgItemMessage(hwnd, IDC_COMBO1, CB_GETCURSEL, 0, 0);
			}
			if (IsDlgButtonChecked(hwnd, IDC_RADIO4) == BST_CHECKED)
				fp=0;
			else
				fp=1;
			etp=GetDlgItemInt(hwnd, IDC_EDIT1, NULL, FALSE);
			if (todo1==0 && etp>100)
			{
				MessageBox(hwnd, "You can't place more than 100 electrons until \"Allow multiple electrons on orbits\" is not checked!", "Atom explosion", MB_OK);
				return 0;
			}
			if (etp>=260)
			{
				MessageBox(hwnd, "Sorry, you've reached the maximum of electrons! Please decrease...", "Atom explosion", MB_OK);
				return 0;
			}
			EndDialog(hwnd, 0);
			return 0;
		case IDCANCEL:
			EndDialog(hwnd, 1);
			return 0;
		}
	}
	return 0;
}

void GB(int x, int y, int c)
{
	if (x>=0 && x<10 && y>=0 && y<10)
	{
		gb[x][y].state++;
		gb[x][y].color=c;
		if (c==-1)
			gb[x][y].state=0;
	}
}

void DestroyAtom(int x, int y)
{
	GB(x-1, y, gb[x][y].color);
	GB(x, y-1, gb[x][y].color);
	GB(x+1, y, gb[x][y].color);
	GB(x, y+1, gb[x][y].color);
	GB(x, y, -1);
	MessageBeep(0xFFFFFFFF);
}

int Explode(void)
{
	int i, j, ntest=0;
	if (gb[0][0].state>=2)
	{
		DestroyAtom(0, 0);
		ntest=1;
	}
	if (gb[9][0].state>=2)
	{
		DestroyAtom(9, 0);
		ntest=1;
	}
	if (gb[0][9].state>=2)
	{
		DestroyAtom(0, 9);
		ntest=1;
	}
	if (gb[9][9].state>=2)
	{
		DestroyAtom(9, 9);
		ntest=1;
	}
	for (i=1; i<9; i++)
	{
		if (gb[0][i].state>=3)
		{
			DestroyAtom(0, i);
			ntest=1;
		}
		if (gb[i][0].state>=3)
		{
			DestroyAtom(i, 0);
			ntest=1;
		}
		if (gb[9][i].state>=3)
		{
			DestroyAtom(9, i);
			ntest=1;
		}
		if (gb[i][9].state>=3)
		{
			DestroyAtom(i, 9);
			ntest=1;
		}
	}
	for (i=1; i<9; i++)
	{
		for (j=1; j<9; j++)
		{
			if (gb[i][j].state>=4)
			{
				DestroyAtom(i, j);
				ntest=1;
			}
		}
	}
	return ntest;
}

int AddElectron(int x, int y)
{
	if (gb[x][y].color!=curp && gb[x][y].state!=0)
		return 1;
	if (gb[x][y].color==-1)
	{
		gb[x][y].state=0;
		gb[x][y].color=curp;
	}

	gb[x][y].state++;
	gb[x][y].color=curp;
	for (;;)
	{
		if (!Explode())
			break;
		DrawBoard(cw);
		if (rc==0 || bc==0)
			break;
	}
	return 0;
}

void GetAtomPos(int state, int color, int *x, int *y)
{
	int i, j;
	for (i=0; i<20; i++)
	{
		for (j=0; j<20; j++)
		{
			switch (color)
			{
			case -1:
				*x=80;
				*y=0;
				break;
			case 0:
				switch (state)
				{
				case 1:
					*x=0;
					*y=20;
					break;
				case 2:
					*x=20;
					*y=20;
					break;
				case 3:
					*x=40;
					*y=20;
					break;
				case 4:
					*x=60;
					*y=20;
					break;
				}
				break;
			case 1:
				switch (state)
				{
				case 1:
					*x=0;
					*y=0;
					break;
				case 2:
					*x=20;
					*y=0;
					break;
				case 3:
					*x=40;
					*y=0;
					break;
				case 4:
					*x=60;
					*y=0;
					break;
				}
				break;
			}
		}
	}
}

int DrawBoard(HWND hwnd)
{
	HWND di;
	HDC hdc;
	RECT rect;
	rc=0;
	bc=0;
	int ec=0, x, y, be=0, re=0;

	di=GetDlgItem(hwnd, IDC_BOARD);
	hdc=GetDC(di);
	
	GetClientRect(di, &rect);
	rect.left++;
	rect.right--;
	rect.top++;
	rect.bottom=25;
	FillRect(hdc, &rect, hbr);
	
	GetClientRect(di, &rect);
	rect.top=235;
	rect.left++;
	rect.right--;
	rect.bottom--;
	FillRect(hdc, &rect, hbr);
	
	GetClientRect(di, &rect);
	rect.top=25;
	rect.bottom=235;
	rect.right=50;
	rect.left++;
	FillRect(hdc, &rect, hbr);
	
	GetClientRect(di, &rect);
	rect.top=25;
	rect.bottom=235;
	rect.left=260;
	rect.right--;
	FillRect(hdc, &rect, hbr);
	
	for (i=0; i<10; i++)
	{
		for (j=0; j<10; j++)
		{
			GetAtomPos(gb[i][j].state, gb[i][j].color, &x, &y);
			StretchBlt(hdc, i*21+50, j*21+25, 20, 20, memdc, x, y, 20, 20, SRCCOPY);
			if (gb[i][j].color==0)
			{
				rc++;
				re+=gb[i][j].state;
			}
			else if (gb[i][j].color==1)
			{
				bc++;
				be+=gb[i][j].state;
			}
			ec+=gb[i][j].state;
		}
	}
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB(255, 30, 0));
	strcpy(buf, "");
	sprintf(buf, "Red player: %d atoms (%d electrons)", rc, re);
	TextOut(hdc, 20, 2, buf, strlen(buf));
	SetTextColor(hdc, RGB(0, 30, 255));
	strcpy(buf, "");
	sprintf(buf, "Blue player: %d atoms (%d electrons)", bc,be);
	TextOut(hdc, 20, 240, buf, strlen(buf));
	SetTextColor(hdc, RGB(46, 46, 135));
	
	SetTextColor(hdc, RGB(0, 0, 0));
	strcpy(buf, "");
	sprintf(buf, "Electrons on orbits (=moves): %d", ec);
	TextOut(hdc, 20, 275, buf, strlen(buf));

	if (curp==0)
		TextOut(hdc, 2, 2, "*", 1);
	else
		TextOut(hdc, 2, 240, "*", 1);
	ReleaseDC(hwnd, hdc);
	return 0;
}

DWORD CALLBACK OpenCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{	
	*pcb = fread((void*)pbBuff, 1, (DWORD)cb, (FILE*)dwCookie);

	if (*pcb <= 0)
		*pcb = 0;
	
	return 0;
}

BOOL CALLBACK AbtDlgProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg)
	{
	case WM_INITDIALOG:
		{
			FILE *file = fopen("readme.rtf", "r");
			EDITSTREAM es;
			es.dwCookie    = (DWORD)file;
			es.dwError	   = 0;
			es.pfnCallback = OpenCallback;
			SendDlgItemMessage(hwnd, IDC_RICHEDIT1, EM_STREAMIN, SF_RTF, (LPARAM)&es);
			fclose(file);
		}
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wparam))
		{
		case IDOK:
			EndDialog(hwnd, 0);
			return 0;
		}
	}
	return 0;
}

BOOL CALLBACK GameDlg(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg)
	{
	case WM_INITDIALOG:		
		cc=0;
		for (i=0; i<10; i++)
		{
			for (j=0; j<10; j++)
			{
				gb[i][j].color=-1;
				gb[i][j].state=0;
			}
			
		}
		bmi.bmiHeader.biWidth = 20;
		bmi.bmiHeader.biHeight = 20;
		bmi.bmiHeader.biPlanes = 1;
		bmi.bmiHeader.biBitCount = 24;
		bmi.bmiHeader.biCompression = BI_RGB;
		bmi.bmiHeader.biSizeImage = 0;
		bmi.bmiHeader.biXPelsPerMeter = 0;
		bmi.bmiHeader.biYPelsPerMeter = 0;
		bmi.bmiHeader.biClrUsed = 0;
		bmi.bmiHeader.biClrImportant = 0;
		bmi.bmiHeader.biSize = sizeof(bmi.bmiHeader);
		hbmp=LoadBitmap(hI, "IMAGE");
		memdc=CreateCompatibleDC(GetDC(GetDlgItem(hwnd, IDC_BOARD)));
		SelectObject(memdc, hbmp);
		hbr=CreateSolidBrush(RGB(200, 200, 200));
		return 0;
	case WM_PAINT:
		DrawBoard(hwnd);
		return 0;
	case WM_LBUTTONDOWN:
		if ((LOWORD(lparam) > 53) && (LOWORD(lparam) < 263) && (HIWORD(lparam) > 27) && (HIWORD(lparam) < 237))
		{
			int x, y;
			x=LOWORD(lparam)-55;
			x/=21;
			y=HIWORD(lparam)-28;
			y/=21;
			cw=hwnd;
			if (AddElectron(x, y))
			{
				MessageBeep(0xFFFFFFFF);
				return 0;
			}
			curp=!curp;
			DrawBoard(hwnd);
			cc++;
			if (cc<2)
				break;
			if (bc==0)
			{
				if (MessageBox(hwnd, "Blue player is the looser! Do you want to restart the game or exit?", "Atom explosions", MB_RETRYCANCEL) == IDRETRY)
				{
					if (DialogBox(hI, "RESTART", hwnd, (DLGPROC)RestartDlgProc) != 0)
					{
						EndDialog(hwnd, 0);
							return 0;
					}
					else
					{
						cw=hwnd;
						RestartGame();
						DrawBoard(hwnd);
					}
				}
				else
					EndDialog(hwnd, 0);
			}
			else if (rc==0)
			{
				if (MessageBox(hwnd, "Red player is the looser!  Do you want to restart the game or exit?", "Atom explosions", MB_RETRYCANCEL) == IDRETRY)
				{
					if (DialogBox(hI, "RESTART", hwnd, (DLGPROC)RestartDlgProc) != 0)
					{
						EndDialog(hwnd, 0);
						return 0;
					}
					else
					{
						cw=hwnd;
						RestartGame();
						DrawBoard(hwnd);
					}
				}
				else
					EndDialog(hwnd, 0);
			}
		}
		else
			MessageBeep(0xFFFFFFFF);
		return 0;
	case WM_MOUSEMOVE:
		{
			/*int x, y;
			HDC hdc;
			RECT rect;
			
			hdc=GetDC(GetDlgItem(hwnd, IDC_BOARD));
			x=LOWORD(lparam)-55;
			if (x<0)
				x=-21;
			x/=21;
			y=HIWORD(lparam)-28;
			if (y<0)
				x=-21;
			y/=21;
			if (x>=0 && x<10 && y>=0 && y<10)
			{
				SetBkMode(hdc, TRANSPARENT);
				SetTextColor(hdc, RGB(20, 20, 20));
				strcpy(buf, "");
				sprintf(buf, "%d.%d : %d electrons on ", x, y, gb[x][y].state);
				if (gb[x][y].color==-1)
					strcat(buf, "unused atom");
				else if (gb[x][y].color==0)
					strcat(buf, "red atom");
				else if (gb[x][y].color==1)
					strcat(buf, "blue atom");
				rect.top=290;
				rect.left=3;
				rect.right=250;
				rect.bottom=310;
				FillRect(hdc, &rect, hbr);
				TextOut(hdc, 20, 290, buf, strlen(buf));
			}
			else
			{
				rect.top=290;
				rect.left=3;
				rect.right=250;
				rect.bottom=310;
				FillRect(hdc, &rect, hbr);
			}
			ReleaseDC(hwnd, hdc);*/
		}
		return 0;
	case WM_COMMAND:
		switch (LOWORD(wparam))
		{
		case IDABOUT:
			DialogBox(hI, "ABOUTDLG", hwnd, (DLGPROC)AbtDlgProc);
			return 0;
		case IDCANCEL:
			if (DialogBox(hI, "RESTART", hwnd, (DLGPROC)RestartDlgProc) != 0)
				return 0;
			cw=hwnd;
			RestartGame();
			DrawBoard(hwnd);
			return 0;
		case IDC_SAVE:
			DialogBox(hI, "SAVEDLG", hwnd, (DLGPROC)SaveDlgProc);
			return 0;
		case IDOK:
			EndDialog(hwnd, 0);
			return 0;
		}
	}
	return 0;
}

int WINAPI WinMain(HINSTANCE hIn, HINSTANCE, char *, int)
{
	HMODULE rtfl;
	hI = hIn;
	InitCommonControls();
	rtfl=LoadLibrary("RICHED32.DLL");
	DialogBox(hIn, "MAINDLG", NULL, (DLGPROC)GameDlg);
	FreeLibrary(rtfl);
	DeleteDC(memdc);
	DeleteObject(hbmp);
	DeleteObject(hbr);
	return 0;
}