/*
 * Decompiled with CFR 0.152.
 */
package minesy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class Board
extends JPanel
implements MouseListener {
    final int CELL_MINE = 1;
    final int CELL_FLAG = 2;
    final int CELL_UNSURE = 4;
    final int CELL_SHOW = 8;
    final int CELL_SIZE = 15;
    int ROWS;
    int COLS;
    int MINES;
    int[][] cells;
    Color c_white;
    Color c_ltgray;
    Color c_flag;
    boolean gameon;

    Board(int n, int n2, int n3) {
        this.init(n, n2, n3);
    }

    public void init(int n, int n2, int n3) {
        this.c_white = new Color(1.0f, 1.0f, 1.0f);
        this.c_ltgray = new Color(0.9f, 0.9f, 0.9f);
        this.c_flag = new Color(0.99f, 0.8f, 0.8f);
        this.addMouseListener(this);
        this.newGame(n, n2, n3);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.COLS * 15 + 1, this.ROWS * 15 + 1);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.ROWS + 1; ++n2) {
            graphics.drawLine(0, n2 * 15, this.COLS * 15, n2 * 15);
        }
        for (n = 0; n < this.COLS + 1; ++n) {
            graphics.drawLine(n * 15, 0, n * 15, this.ROWS * 15);
        }
        for (n2 = 0; n2 < this.ROWS; ++n2) {
            for (n = 0; n < this.COLS; ++n) {
                int n3;
                if ((this.cells[n2][n] & 8) == 8) {
                    graphics.setColor(this.c_white);
                } else if ((this.cells[n2][n] & 2) == 2 || (this.cells[n2][n] & 4) == 4) {
                    graphics.setColor(this.c_flag);
                } else {
                    graphics.setColor(this.c_ltgray);
                }
                graphics.fillRect(n * 15 + 1, n2 * 15 + 1, 14, 14);
                if (!this.gameon && (this.cells[n2][n] & 1) == 1) {
                    graphics.setColor(Color.red);
                    graphics.drawString("@", n * 15 + 3, n2 * 15 + 15 - 2);
                }
                if ((this.cells[n2][n] & 2) == 2) {
                    graphics.setColor(Color.blue);
                    graphics.drawString("#", n * 15 + 3, n2 * 15 + 15 - 2);
                }
                if ((this.cells[n2][n] & 4) == 4) {
                    graphics.setColor(Color.blue);
                    graphics.drawString("?", n * 15 + 3, n2 * 15 + 15 - 2);
                }
                graphics.setColor(Color.black);
                if ((this.cells[n2][n] & 8) != 8 || (n3 = this.minesAround(n, n2)) == 0) continue;
                graphics.drawString("" + n3, n * 15 + 3, n2 * 15 + 15 - 2);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void gameOver(int n) {
        this.gameon = false;
        this.repaint();
        if (n == 1) {
            JOptionPane.showMessageDialog(this, "Congrats, you won! ;-)");
        } else {
            JOptionPane.showMessageDialog(this, "You are a looser, better try it again :-P");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.gameon) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getButton();
        if (n < (this.COLS + 1) * 15 && n2 < (this.ROWS + 1) * 15 && n >= 0 && n2 >= 0) {
            n /= 15;
            n2 /= 15;
            switch (n3) {
                case 1: {
                    switch (this.explore(n, n2)) {
                        case 0: {
                            if (this.isWon()) {
                                this.gameOver(1);
                                break;
                            }
                            this.repaint();
                            break;
                        }
                        case 1: {
                            this.gameOver(0);
                        }
                    }
                    break;
                }
                case 3: {
                    if ((this.cells[n2][n] & 0xE) == 0) {
                        int[] nArray = this.cells[n2];
                        int n4 = n;
                        nArray[n4] = nArray[n4] | 2;
                        this.repaint();
                        break;
                    }
                    if ((this.cells[n2][n] & 2) == 2) {
                        this.cells[n2][n] = this.cells[n2][n] & 0xFFFFFFFD | 4;
                        this.repaint();
                        break;
                    }
                    if ((this.cells[n2][n] & 4) != 4) break;
                    this.cells[n2][n] = this.cells[n2][n] & 0xFFFFFFFB;
                    this.repaint();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void newGame(int n, int n2, int n3) {
        this.newBoard(n, n2, n3);
        this.gameon = true;
        this.repaint();
    }

    private void newBoard(int n, int n2, int n3) {
        int n4;
        int n5;
        this.ROWS = n;
        this.COLS = n2;
        this.MINES = n3;
        this.cells = new int[this.ROWS][this.COLS];
        for (n5 = 0; n5 < this.ROWS; ++n5) {
            for (n4 = 0; n4 < this.COLS; ++n4) {
                this.cells[n5][n4] = 0;
            }
        }
        int n6 = 0;
        while (n6 < this.MINES) {
            n4 = (int)(Math.random() * (double)this.COLS);
            n5 = (int)(Math.random() * (double)this.ROWS);
            if (this.cells[n5][n4] != 0) continue;
            this.cells[n5][n4] = 1;
            ++n6;
        }
    }

    private boolean inCells(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.COLS && n2 < this.ROWS;
    }

    private int isMine(int n, int n2) {
        if (!this.inCells(n, n2)) {
            return 0;
        }
        return (this.cells[n2][n] & 1) == 1 ? 1 : 0;
    }

    private int minesAround(int n, int n2) {
        return this.isMine(n - 1, n2 - 1) + this.isMine(n - 1, n2) + this.isMine(n - 1, n2 + 1) + this.isMine(n, n2 - 1) + this.isMine(n, n2) + this.isMine(n, n2 + 1) + this.isMine(n + 1, n2 - 1) + this.isMine(n + 1, n2) + this.isMine(n + 1, n2 + 1);
    }

    private int explore(int n, int n2) {
        if (!this.inCells(n, n2) || (this.cells[n2][n] & 8) == 8) {
            return 0;
        }
        if ((this.cells[n2][n] & 1) == 1) {
            this.cells[n2][n] = 9;
            return 1;
        }
        this.cells[n2][n] = 8;
        if (this.minesAround(n, n2) == 0) {
            this.explore(n - 1, n2 - 1);
            this.explore(n + 1, n2 + 1);
            this.explore(n + 1, n2 - 1);
            this.explore(n - 1, n2 + 1);
            this.explore(n - 1, n2);
            this.explore(n + 1, n2);
            this.explore(n, n2 - 1);
            this.explore(n, n2 + 1);
        }
        return 0;
    }

    private boolean isWon() {
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLS; ++j) {
                if ((this.cells[i][j] & 1) == 1 || (this.cells[i][j] & 8) == 8) continue;
                return false;
            }
        }
        return true;
    }
}

