/*
 * Decompiled with CFR 0.152.
 */
package minesy;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import minesy.Board;
import minesy.SettingsDialog;

public class Minesy
extends JFrame
implements ActionListener {
    protected boolean inAnApplet = true;
    protected JMenuBar mbar;
    protected JMenuItem iNewGame;
    protected JMenuItem iSettings;
    protected JMenuItem iQuit;
    protected JMenuItem iHelp;
    protected JMenuItem iAbout;
    protected Board board = null;
    private int nx = 10;
    private int ny = 10;
    private int nm = 10;

    public Minesy() {
        this.setTitle("Minesy ;-)");
        this.setSize(500, 400);
        this.setResizable(false);
        this.iNewGame = new JMenuItem("New Game", 78);
        this.iNewGame.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.iSettings = new JMenuItem("Settings", 83);
        this.iSettings.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.iQuit = new JMenuItem("Quit", 81);
        this.iQuit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.mbar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.iNewGame.setActionCommand("NewGame");
        this.iNewGame.addActionListener(this);
        jMenu.add(this.iNewGame);
        this.iSettings.setActionCommand("Settings");
        this.iSettings.addActionListener(this);
        jMenu.add(this.iSettings);
        jMenu.addSeparator();
        this.iQuit.setActionCommand("Quit");
        this.iQuit.addActionListener(this);
        jMenu.add(this.iQuit);
        this.mbar.add(jMenu);
        this.iHelp = new JMenuItem("Help...", 72);
        this.iHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.iAbout = new JMenuItem("About...");
        this.iAbout.setAccelerator(KeyStroke.getKeyStroke(112, 8));
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic(72);
        this.iHelp.setActionCommand("Help");
        this.iHelp.addActionListener(this);
        jMenu2.add(this.iHelp);
        jMenu2.addSeparator();
        this.iAbout.setActionCommand("About");
        this.iAbout.addActionListener(this);
        jMenu2.add(this.iAbout);
        this.mbar.add(jMenu2);
        this.setJMenuBar(this.mbar);
        this.board = new Board(this.nx, this.ny, this.nm);
        this.getContentPane().add((Component)this.board, "Center");
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("NewGame")) {
            this.board.newGame(this.nx, this.ny, this.nm);
            this.pack();
        } else if (string.equals("Quit")) {
            this.quit();
        } else if (string.equals("Help")) {
            Object[] objectArray = new Object[]{"Yes, please", "No, thanks"};
            while (JOptionPane.showOptionDialog(this, "Don't you know how to play mines?\nLeft click - discovers the field\nRight click - puts/removes flag\nThe game is won, when just fields containing mines are hidden\nThe rest is up on you ;-)\nDo you want more information?", "Help", 0, 3, null, objectArray, objectArray[1]) == 0) {
            }
        } else if (string.equals("About")) {
            JOptionPane.showMessageDialog(this, "(c) 2005 Andrej Krutak\nRedistributable under the GPL v2.0 or later ;-)");
        } else if (string.equals("Settings")) {
            SettingsDialog settingsDialog = new SettingsDialog((Frame)this, this.nx, this.ny, this.nm);
            this.nx = settingsDialog.x;
            this.ny = settingsDialog.y;
            this.nm = settingsDialog.n;
        }
    }

    public void quit() {
        System.exit(0);
    }

    public void main2() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Minesy minesy = this;
        minesy.inAnApplet = false;
        minesy.pack();
        minesy.setVisible(true);
    }

    public static void main(String[] stringArray) {
        Minesy minesy = new Minesy();
        minesy.main2();
    }

    public void execute() {
        this.main2();
    }
}

