package minesy;

import javax.swing.JOptionPane;
import javax.swing.JDialog;
import javax.swing.JTextField;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.*;


/**
 * The Minesy is a java implementation of the famous Minesweeper game ;-)
 *
 * @author Andrej Krutak
*/

public class Minesy extends JFrame implements ActionListener {
	protected boolean inAnApplet = true;
	protected JMenuBar mbar;
	protected JMenuItem iNewGame, iSettings, iQuit, iHelp, iAbout;
	protected Board board=null;
	private int nx, ny, nm;
	
	/**
	 * Creates main window - menus, sets window size, creates board
	 */
	public Minesy() {
		nx=10;
		ny=10;
		nm=10;
		
		setTitle("Minesy ;-)");
		setSize(500,400);
		setResizable(false);
		
		iNewGame = new JMenuItem("New Game", KeyEvent.VK_N);
		iNewGame.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
		iSettings = new JMenuItem("Settings", KeyEvent.VK_S);
		iSettings.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
		iQuit = new JMenuItem("Quit", KeyEvent.VK_Q);
		iQuit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, ActionEvent.ALT_MASK));

		mbar = new JMenuBar();
			JMenu file = new JMenu("File");
			file.setMnemonic(KeyEvent.VK_F);
			iNewGame.setActionCommand("NewGame");
			iNewGame.addActionListener(this);
			file.add(iNewGame);
			iSettings.setActionCommand("Settings");
			iSettings.addActionListener(this);
			file.add(iSettings);
			file.addSeparator();
			iQuit.setActionCommand("Quit");
			iQuit.addActionListener(this);
			file.add(iQuit);
			mbar.add(file);

			iHelp = new JMenuItem("Help...", KeyEvent.VK_H);
			iHelp.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
			iAbout = new JMenuItem("About...");
			iAbout.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, ActionEvent.ALT_MASK));
			JMenu help = new JMenu("Help");
			help.setMnemonic(KeyEvent.VK_H);
			iHelp.setActionCommand("Help");
			iHelp.addActionListener(this);
			help.add(iHelp);
			help.addSeparator();
			iAbout.setActionCommand("About");
			iAbout.addActionListener(this);
			help.add(iAbout);
			mbar.add(help);
		setJMenuBar(mbar);

		board=new Board(nx, ny, nm);
		
		getContentPane().add(board, BorderLayout.CENTER);
	}
	
	/**
	 * Standard function - processes events like WINDOW_CLOSING etc.
	 * @param e event sent to window
	 */
	public void processWindowEvent(WindowEvent e) {
		if(e.getID() == WindowEvent.WINDOW_CLOSING)
			System.exit(0);
	}
	
	/**
	 * Standard function - processes actions like menu item selection
	 * @param e action performed
	 */
	public void actionPerformed(ActionEvent e) {
		String c = e.getActionCommand();

		if (c.equals("NewGame")) {
			board.newGame(nx, ny, nm);
			pack();
		}
		else if (c.equals("Quit")) quit();
		else if (c.equals("Help")) {
			Object[] options = {"Yes, please", "No, thanks"};
			while (JOptionPane.showOptionDialog(this, "Don't you know how to play mines?\nLeft click - discovers the field\nRight click - puts/removes flag\nThe game is won, when just fields containing mines are hidden\nThe rest is up on you ;-)\nDo you want more information?", "Help", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[1])==0);
		} else if (c.equals("About"))
			JOptionPane.showMessageDialog(this, "(c) 2005 Andrej Krutak\nRedistributable under the GPL v2.0 or later ;-)");
		else if (c.equals("Settings")) {
			SettingsDialog dlg=new SettingsDialog(this, nx, ny, nm);
			nx=dlg.x;
			ny=dlg.y;
			nm=dlg.n;
		}
	}
	
	/**
	 * Called to quit the program
	 */
	public void quit() {
		System.exit(0);
	} 
	
	/**
	 * The real main function - initializes main window
	 */
	public void main2() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) { }
		
		Minesy window = this;
		window.inAnApplet = false;
		
		window.pack();
		window.setVisible(true);
	}
	
	/**
	 * Stub main - just calls main2
	 */
	public static void main(String args[]) {
		Minesy m = new Minesy();
		m.main2();
	}
	
	/**
	 * Stub main - just calls main2
	 */
	public void execute() {
		main2();
	}
} 
